public class Matrix {
    private double[][] data;	// Reference to array

    public Matrix(int m, int n) {
        data = new double[m][n];
    }

    public void setIdentity() {
        int nrows = data.length;
        int ncols = data[0].length;
        for(int i=0; i<nrows; i++)
            for(int j=0; j<ncols; j++)
                if(i == j)
                    data[i][j]= 1.0;
                else
                    data[i][j]= 0.0;
    }	// Should check that matrix is square

    public int getNumRows() {
        return data.length;
    }

    public int getNumCols() {
        return data[0].length;
    }

    public double getElement(int i, int j) {
        return data[i][j];
    }
    
    public void setElement(int i, int j, double val) {
        data[i][j] = val;
    }
    
    public void incrElement(int i, int j, double incr) {
    	data[i][j] += incr;
    }
    
    public Matrix add(Matrix b) {
        Matrix result = null;
        int nrows = data.length;
        int ncols = data[0].length;
        if (nrows == b.data.length && ncols == b.data[0].length) {
            result = new Matrix(nrows, ncols);
            for(int i=0; i<nrows; i++)
                for(int j=0; j<ncols; j++)
                    result.data[i][j]= this.data[i][j] + b.data[i][j];
        }
        return result;
    }	// Objects of same class see each others' private data
    
    public Matrix mult(Matrix b) {
        Matrix result = null;
        int nrows = data.length;
        int ncols = data[0].length;
        if(ncols == b.data.length) {
            result = new Matrix(nrows, b.data[0].length);
            for(int i=0; i<nrows; i++)
                for(int j=0; j<result.data[0].length; j++) {
                    double t = 0.0;
                    for(int k=0; k < ncols; k++) {
                        t += data[i][k] * b.data[k][j];
                    }
                    result.data[i][j]= t;
                }
        }
        return result;
    }
    
    public void print() {
            for(int i=0; i< data.length; i++) {
                for(int j=0; j< data[0].length; j++)
                    System.out.print(data[i][j] + " ");
                System.out.println();
            }
        System.out.println();
    }
}